<?php

/**
*
* Hromszerepls fizetsi tranzakci indtsa illetve az eredmny
* meggjelentse PHP krnyezetbl.
*
* Az indtst a process metdus vgzi, mely az OTP Internetes Fizetsi Fellet
* oldalra tovbbtja a kliens krst, mikzben elindtja a
* WebShopClient SOAP felletn keresztl trtn tranzakcit.
*
* A vev trnytsa egy HTTP redirect header-t tartalmaz vlasz sszelltsval
* s elkldsve trtnik. A fizetsi tranzakci banki felleten trtn indtsa
* ekkor kezddik. Vagyis nincs sz igazi prhuzamossgrl, csupn arrl, hogy
* a vev ltal indtott HTTP krs - br a kliens oldali bngszt trnytja
* a banki felletre - a valsgban jval tovbb dolgozdik fel, s majd akkor r
* vget, mikor a bank feldolgozza a vev oldali felleten megadott krtyaadatokkal
* vgrehajtand terhelst.
*
* Megjegyzs: a BackUrl-t kldsnl dinamikusan lltjuk ssze gy,
* hogy erre a szervletre mutasson, s tartalmazza a tranzakci adatait (posId
* s tranzakci id) valamint egy jelzt, hogy a krsnek egy sikeroldalt kell
* megjelentenie, s nem fizetsi folyamatot indtania. E sikeroldal
* megjelentst a processDirectedToBackUrl vgzi el.
*
* A vlasz feldolgozst a processDirectedToBackUrl metdus vgzi, amit - ahogy
* a neve is mutatja - a backUrl-lel megcmzett programkdban clszer meghvni.
* A processDirectedToBackUrl metdus alaprtelmezett mkdse:
* - Lekrdezi a tranzakci eredmnyt a tranzakcioStatuszLekerdezes szolgltats
* hvssal, s kielemzi a lekrdezett fizetsi tranzakci adatait.
* - Amennyiben a fizetsi tranzakci sikeresen lefutott, a kliens oldal 
* a "webshop_success_answerpage_url" paramterben megadott url-re fog kerlni, 
* mely url-be rendre az albbi rtkek fognak behelyettestdni: posId, 
* tranzakci azonost, authorizcis kd.
* - Amennyiben a fizetsi tranzakci sikertelenl futott le (krtyaterhelsi
* hiba, idtllps vagy egyb hiba miatt), akkor a "webshop_failed_answerpage_url" 
* paramterben megadott url-re fog kerlni a vezrls, a posId, tranzakci azonost 
* s hibakd behelyettestdse utn.
* - Amennyiben a fizetsi tranzakcit az gyfl elutastotta sikertelenl futott le, 
* akkor a "webshop_cancelled_answerpage_url" paramterben megadott url-re fog kerlni 
* a vezrls, a posId, tranzakci azonost behelyettestdse utn.
* - Egyb esetben (megszakadt kommunikci, vagy a vlasz feldolgozs
* hibt jelez) a webshop_unknown_answerpage_url paramterben megadott url-re 
* fog kerlni a vezrls, a posId s tranzakci azonost behelyettestdse utn.
* A vezrlstads trtnhet a PHP include utastsval vagy bngsz oldali
* redirectlssal.
*
* A vonatkoz paramterek a haromszereplosshop.conf fjlban konfigurlhatak.
*
* A processDirectedToBackUrl metdus megfelel paramterezse mellett a vezrlstads 
* lps kihagyhat. Ilyenkor a metdus visszatrsi rtke hasznlhat, mely a 
* fizetsi tranzakci vlaszt tartalmazza. Ugyancsak hozzfrhet a fizetsi vlasz
* objektum akkor, ha a fenti url jelleg paramter loklis php kdra trtn
* hivatkozst tartalmaznak, amit a kontroller include-olhat.
*
* A feldolgozs tmogatja a ktlpcss fizetsi mdot: ha paramterknt tadsra
* kerl a ketlepcsosFizetes jelz, akkor annak logikai rtke explicit mdon
* tadsra kerl a Bank fel kldtt krsben.
*
* A forrskd demonstrcis jelleg, szabadon mdosthat.
*
* @version 4.0
* 
*/

define('SIMPLESHOP_CONFIGURATION', '../config/haromszereplosshop.conf');

if (!defined('WEBSHOP_LIB_DIR')) define('WEBSHOP_LIB_DIR', dirname(__FILE__) . '/../lib');

require_once(WEBSHOP_LIB_DIR . '/iqsys/otpwebshop/WebShopService.php');
//require_once(WEBSHOP_LIB_DIR . '/iqsys/otpwebshop/WebShopServiceSimulator.php');
require_once(WEBSHOP_LIB_DIR . '/iqsys/otpwebshop/util/RequestUtils.php');
require_once(WEBSHOP_LIB_DIR . '/iqsys/otpwebshop/util/ConfigUtils.php');

/**
* @desc Hromszerepls fizetsi tranzakci indtsa, a bank oldali
* kommunikci lebonyoltsval s a vev oldali (bngsz) fellet
* megfelel tirnytsval.
* 
* Automatikus redirektls / include-ols esetn definilsra kerl rtkek
* illetve global vltozk:
* "response" => WResponse tpus objektum, mely a fizetsi tranzakcihoz
*               tartoz sszes vlaszadatot tartalmazza
* "tranzAdatok" => WebShopFizetesValasz tpus objektum, a 
*                  vsrlshoz tartoz vlaszobjektum (value object)
* 
* @return a fizetsi tranzakci banki fellet ltal visszaadott s 
* rtelmezett rtke, WResponse tpus objektum. 
*/
function process() {

    ob_start();

    $config = parse_ini_file(SIMPLESHOP_CONFIGURATION);
    $service = new WebShopService();

    // Paramterek sszegyjtse a krsbl
    $posId = RequestUtils::safeParam($_REQUEST, 'posId');
    $tranzAzon = RequestUtils::safeParam($_REQUEST, 'tranzakcioAzonosito');
    $nyelvkod = RequestUtils::safeParam($_REQUEST, 'nyelvkod');

    if (is_null($tranzAzon) || (trim($tranzAzon) == "")) {
        $tranzAzonResponse =  $service->tranzakcioAzonositoGeneralas($posId);
        if ($tranzAzonResponse->hasSuccessfulAnswer) {
            $tranzAzon = $tranzAzonResponse->answerModel->getAzonosito();
        }
    }
    
    if (is_null($tranzAzon) || (trim($tranzAzon) == "")) {
        processDirectedToBackUrl();
        return;
    }
    
    // gyfl tirnytsa a vev oldali felletre
    $custPageTemplate = $config['webshop_customerpage_url'];
    $custPageTemplate = ConfigUtils::substConfigValue($custPageTemplate,
        array("0" => urlencode($posId),
              "1" => urlencode($tranzAzon),
              "2" => urlencode($nyelvkod)));

    header("Connection: close");
    header("Location: " . $custPageTemplate);
    header("Content-Length: " . ob_get_length());
    header("Content-Encoding: none");
    ob_end_flush();
    flush();

    // BackURL maniplci
    $backUrl = $_REQUEST['backURL'];
    if (!is_null($backUrl) && trim($backUrl) != '') {
        if (ConfigUtils::getConfigParamBool($config, 'append_trandata_to_backurl', $posId, true)) {
            $backUrl =
                RequestUtils::addUrlQuery($backUrl,
                    array('fizetesValasz' => 'true',
                          'posId' => $posId,
                          'tranzakcioAzonosito' => $tranzAzon));
        }
    }

    syslog(LOG_NOTICE, "Haromszereplos fizetes keres kuldes: " . $posId . " - " . $tranzAzon);

    global $response;
    // Fizetsi tranzakci elindtsa
    $response = $service->fizetesiTranzakcio(
        $posId,
        $tranzAzon,
        RequestUtils::safeParam($_REQUEST, 'osszeg'),
        RequestUtils::safeParam($_REQUEST, 'devizanem'),
        $nyelvkod,
        RequestUtils::safeParam($_REQUEST, 'nevKell'),
        RequestUtils::safeParam($_REQUEST, 'orszagKell'),
        RequestUtils::safeParam($_REQUEST, 'megyeKell'),
        RequestUtils::safeParam($_REQUEST, 'telepulesKell'),
        RequestUtils::safeParam($_REQUEST, 'iranyitoszamKell'),
        RequestUtils::safeParam($_REQUEST, 'utcaHazszamKell'),
        RequestUtils::safeParam($_REQUEST, 'mailCimKell'),
        RequestUtils::safeParam($_REQUEST, 'kozlemenyKell'),
        RequestUtils::safeParam($_REQUEST, 'vevoVisszaigazolasKell'),
        RequestUtils::safeParam($_REQUEST, 'ugyfelRegisztracioKell'),
        RequestUtils::safeParam($_REQUEST, 'regisztraltUgyfelId'),
        RequestUtils::safeParam($_REQUEST, 'shopMegjegyzes'),
        $backUrl,
        RequestUtils::safeParam($_REQUEST, 'zsebAzonosito'),
        RequestUtils::safeParam($_REQUEST, "ketlepcsosFizetes"));

    /*********
     Itt a helye a shop-specifikus eredmny feldolgozsnak / trolsnak
     ********/

    if ($response) {
        syslog(LOG_NOTICE, "Haromszereplos fizetes keres kuldes: " . $posId . " - " . $tranzAzon . " - " . implode($response->getMessages()));
    }
    else {
        syslog(LOG_ERR, "Haromszereplos fizetes keres kuldes: " . $posId . " - " . $tranzAzon . " - NEM ERTELMEZHETO VALASZ!");
    }
    
    return $response;
}

/**
 * processDirectedToBackUrl
 * A hromszerepls fizets eredmnynek megjelentse a shop oldalon.
 * E megjelentsnek akkor van komoly szerepe, amikor a fizetsi tranzakciban a
 * <i>vevoVisszaigazolas</i> paramter rtke hamis volt. Ekkor ugyanis az
 * Internetes Fizetsi Fellet "tovbbrnytja" a vlaszoldal
 * megjelentst a <i>backURL</i> rtkben tadott oldalra. Sikeres s
 * sikertelen tranzakci esetn egyarnt ez az oldal jelenik meg, ezrt van
 * szksg dinamikus (a fizets eredmnytl fgg) megjelentsre.
 *
 * A metdus lekrdezi a fizetsi tranzakci adatt, s annak megfelelen
 * jelenti meg a hiba oldalt vagy az eredmny oldalt.
 * 
 * Az include-ols esetn definilsra kerl rtkek illetve global vltozk:
 * "tranzAdatok" => WebShopFizetesValasz tpus objektum, a 
 *                  vsrlshoz tartoz vlaszobjektum (value object)
 *
 * @param $doRedirect a fizetsi tranzakci vgrehajtsa utn vgre kell-e
 * hajtani az eredmnyoldalakra trtn redirect / include lpseket a
 * haromszereplosshop.conf (vagy a 'SIMPLESHOP_CONFIGURATION'-ban megadott)
 * llomnyban lert url-ek alapjn. [Alaprtelmezett rtk: true]
 * 
 * @return WebShopFizetesAdatok a fizetsi tranzakci input- s eredmny adatait
 *         tartalmaz value object. NULL, ha sikertelen volt a tranzakci 
 *         adatainak lekrdezse
 * 
 */
function processDirectedToBackUrl($doRedirect = true) {

    $posId = $_REQUEST['posId'];
    $tranzAzon = $_REQUEST['tranzakcioAzonosito'];

    $config = parse_ini_file(SIMPLESHOP_CONFIGURATION);

    $successAnswerPage =
        ConfigUtils::getConfigParam($config, 'webshop_success_answerpage_url', $posId);
    $cancelledAnswerPage =
        ConfigUtils::getConfigParam($config, 'webshop_cancelled_answerpage_url', $posId);
    $failedAnswerPage =
        ConfigUtils::getConfigParam($config, 'webshop_failed_answerpage_url', $posId);
    $unknownAnswerPage =
        ConfigUtils::getConfigParam($config, 'webshop_unknown_answerpage_url', $posId);

    global $tranzAdatok;
        
    if (!is_null($tranzAzon) && (trim($tranzAzon) != "")) {
        syslog(LOG_NOTICE, "Fizetes tranzakcio adat lekerdezes: " + $tranzAzon);

        // Lekrdezzk a fizetsi tranzakci adatait.
        // A lekrdezett tranzakcira definilunk egy idintervallumot is:
        // [aktulis idpont - 24 ra ; aktulis idpont + 24 ra]
        $service = new WebShopService();
        $response = $service->tranzakcioStatuszLekerdezes($posId, $tranzAzon, 1, time() - 60*60*24, time() + 60*60*24);

        if ($response) {

            $answer = $response->getAnswer();
            if ($response->isSuccessful()
                    && $response->getAnswer()
                    && count($answer->getWebShopFizetesAdatok()) > 0) {

                // Sikerlt lekrdezni az adott tranzakci adatt
                $fizetesAdatok = $answer->getWebShopFizetesAdatok();
                $tranzAdatok = current($fizetesAdatok);
                $_REQUEST['tranzAdatok'] = $tranzAdatok;

                syslog(LOG_NOTICE, "Fizetes tranzakcio adat lekerdezes befejezve: " . $posId . " - " . $tranzAzon );

                $responseCode = $tranzAdatok->getPosValaszkod();

                $successPosResponseCodes = array(
                    "000", "00", "001", "002", "003", "004",
                    "005", "006", "007", "008", "009", "010");

                if ($tranzAdatok->isSuccessful()) {
                    // Az gyfl megfelelen kitlttte s elkldte
                    // az adatait, a vsrls vagy regisztrls sikeres volt
                    $successAnswerPage = ConfigUtils::substConfigValue($successAnswerPage,
                        array("0" => urlencode($posId),
                              "1" => urlencode($tranzAzon),
                              "2" => urlencode($tranzAdatok->getAuthorizaciosKod())));
                    if ($doRedirect) RequestUtils::includeOrRedirect($successAnswerPage);
                }
                else if ("VISSZAUTASITOTTFIZETES" == $responseCode) {
                    // Az gyfl elutastotta (visszavonta) a vsrlst a vev oldali felleten
                    $cancelledAnswerPage = ConfigUtils::substConfigValue($cancelledAnswerPage,
                        array("0" => urlencode($posId),
                              "1" => urlencode($tranzAzon)));
                    if ($doRedirect) RequestUtils::includeOrRedirect($cancelledAnswerPage);
                }
                else {
                    // Az gyfl kitlttte s elkldte az adatait,
                    // de a tranzakci sikertelen volt.
                    // Valsznleg a krtya terhels nem vgezhet el
                    $failedAnswerPage = ConfigUtils::substConfigValue($failedAnswerPage,
                        array("0" => urlencode($posId),
                              "1" => urlencode($tranzAzon),
                              "2" => urlencode($responseCode)));
                    if ($doRedirect) RequestUtils::includeOrRedirect($failedAnswerPage);
                }
            }
            else {
                // Ha nem sikerlt lekrdezni a vlaszt...
                $unknownAnswerPage = ConfigUtils::substConfigValue($unknownAnswerPage,
                    array("0" => urlencode($posId),
                          "1" => urlencode($tranzAzon)));
                if ($doRedirect) RequestUtils::includeOrRedirect($unknownAnswerPage);
            }
        }
        else {
            // Ha nem sikerlt lekrdezni a vlaszt...
            $unknownAnswerPage = ConfigUtils::substConfigValue($unknownAnswerPage,
                array("0" => urlencode($posId),
                      "1" => urlencode($tranzAzon)));
            if ($doRedirect) RequestUtils::includeOrRedirect($failedAnswerPage);
        }
    }
    else {
        $unknownAnswerPage = ConfigUtils::substConfigValue($unknownAnswerPage,
            array("0" => urlencode($posId),
                  "1" => urlencode($tranzAzon)));
        if ($doRedirect) RequestUtils::includeOrRedirect($unknownAnswerPage);
    }
    
    return $tranzAdatok;
}

?>