<?php

/**
*
* Kulcs lekrdezs/generls indtsa PHP krnyezetbl. Az indtst a
* process metdus vgzi, mely a banki SOAP fellet kzvetlen meghvsval
* elindtja a tranzakcit.
*
* A forrskd demonstrcis jelleg, szabadon mdosthat.
*
* @author Lszlk Zsolt, EQLSoft
* @version 4.0
*
*/

define('SIMPLESHOP_CONFIGURATION', '../config/shopkulcslekerdezes.conf');

if (!defined('WEBSHOP_LIB_DIR')) define('WEBSHOP_LIB_DIR', dirname(__FILE__) . '/../lib');

require_once(WEBSHOP_LIB_DIR . '/iqsys/otpwebshop/WebShopService.php');
//require_once(WEBSHOP_LIB_DIR . '/iqsys/otpwebshop/WebShopServiceSimulator.php');
require_once(WEBSHOP_LIB_DIR . '/iqsys/otpwebshop/util/RequestUtils.php');

/**
 * Kulcs lekrdezsnek indtsa, a bank oldali
 * kommunikci lebonyoltsval.
 *
 * @return WResponse a kulcs lekrdezs banki fellet ltal visszaadott
 * vlaszt reprezentl value object.
 */
function process() {

	global $size;
	global $lista;
	global $privateKey;
	
	$config = parse_ini_file(SIMPLESHOP_CONFIGURATION);
	
    $posId = RequestUtils::safeParam($_REQUEST, 'posId');
    $muvelet = RequestUtils::safeParam($_REQUEST, 'muvelet');

    $service = new WebShopService();

    $response = $service->kulcsLekerdezes($posId, $muvelet);
    
    $lista = $response->getAnswer();
    $privateKey = $lista->getPrivateKey();
    
    if (!empty($privateKey))
    {
    	//Kulcs generls
    	
    	$savePath = ConfigUtils::getConfigParam($config, 'keyfile_save_path');
    	$fileName = $posId . '_' . date('YmdHis') . '.zip';
    	$size = file_put_contents($savePath . DIRECTORY_SEPARATOR . $fileName, base64_decode($privateKey));        	
    }

    return $response;
}

?>
