<?php

/**
*
* Fizetsi tranzakci lekrdezs indtsa PHP krnyezetbl. Az indtst a
* process metdus vgzi, mely a banki SOAP fellet kzvetlen meghvsval
* elindtja a tranzakci lekrdezst.
*
* Ne feledjk, hogy a tranzakcik "utlagos" lekrdezse nem ktdik a vevhz,
* hiszen tisztn bolti / adminisztratv jelleg tevkenysgrl van sz.
* 
* A forrskd demonstrcis jelleg, szabadon mdosthat.
*
* @version 4.0
* 
*/

if (!defined('WEBSHOP_LIB_DIR')) define('WEBSHOP_LIB_DIR', dirname(__FILE__) . '/../lib');

require_once(WEBSHOP_LIB_DIR . '/iqsys/otpwebshop/WebShopService.php');
//require_once(WEBSHOP_LIB_DIR . '/iqsys/otpwebshop/WebShopServiceSimulator.php');
require_once(WEBSHOP_LIB_DIR . '/iqsys/otpwebshop/util/RequestUtils.php');

/**
 * Fizetsi tranzakcik lekrdezsnek indtsa, a bank oldali
 * kommunikci lebonyoltsval.
 *
 * @return WResponse a fizetsi tranzakci lekrdezs banki fellet ltal visszaadott
 * vlaszt reprezentl value object.
 */
function process() {

    $posId = RequestUtils::safeParam($_REQUEST, 'posId');
    $tranzAzon = RequestUtils::safeParam($_REQUEST, 'tranzakcioAzonosito');
    $maxRekordSzam = RequestUtils::safeParam($_REQUEST, 'maxRekordSzam');

    $idoszakElejeChecked = RequestUtils::getBooleanValue($_REQUEST['idoszakEleje']);
    $idoszakVegeChecked = RequestUtils::getBooleanValue($_REQUEST['idoszakVege']);

    if ($idoszakElejeChecked)
        global $idoszakEleje;
        $idoszakEleje = mktime(
            RequestUtils::safeParam($_REQUEST, 'idoszakEleje_ora'),
            RequestUtils::safeParam($_REQUEST, 'idoszakEleje_perc'),
            0,
            RequestUtils::safeParam($_REQUEST, 'idoszakEleje_honap'),
            RequestUtils::safeParam($_REQUEST, 'idoszakEleje_nap'),
            RequestUtils::safeParam($_REQUEST, 'idoszakEleje_ev')) ;
    if ($idoszakVegeChecked)
        global $idoszakVege;
        $idoszakVege = mktime(
            RequestUtils::safeParam($_REQUEST, 'idoszakVege_ora'),
            RequestUtils::safeParam($_REQUEST, 'idoszakVege_perc'),
            59,
            RequestUtils::safeParam($_REQUEST, 'idoszakVege_honap'),
            RequestUtils::safeParam($_REQUEST, 'idoszakVege_nap'),
            RequestUtils::safeParam($_REQUEST, 'idoszakVege_ev'));

    $service = new WebShopService();

    $response = $service->tranzakcioStatuszLekerdezes(
        $posId,
        $tranzAzon,
        $maxRekordSzam,
        $idoszakElejeChecked ? $idoszakEleje : NULL,
        $idoszakVegeChecked ? $idoszakVege : NULL);

    return $response;
}

?>