<?php 
    /**
    * @desc Plda olyan eredmny oldalra, melyre a ktszerepls
    * fizets sikeres vgrehajtsa utn trtnik a vezrlstads
    * PHP kdbeli include / require utastssal.
    * 
    * Az llomnyt a pldnkban a fiz2_control.php include-olja,
    * a ketszereplosshop.conf fjl megfelel konfigurlsa esetn.
    * Ilyenkor kt global lthatsg PHP objektum vltoz ll
    * rendelkezsre, mely tartalmazza a fizets sszes vlaszadatt:
    * - tranzAdatok: WebShopFizetesValasz tpus objektum, a 
    *   vsrlshoz tartoz vlaszobjektum (value object)
    * 
    * Megjegyzs: a fizetsi tranzakci eredmnye (tranzAdatok) a 
    * Tranzakci  lekrdezs funkci meghvsval kerl lekrdezsre.
    * A vlasz feldolgozst eszerint kell elvgezni: a vssls
    * akkor sikeres, ha a POS vlaszkd 000-010 kzti rtk,
    * s az authorizcis kd nem res.
    */

    if (!defined('WEBSHOP_LIB_DIR')) define('WEBSHOP_LIB_DIR', dirname(__FILE__) . '/../lib');
    require_once(WEBSHOP_LIB_DIR . '/iqsys/otpwebshop/util/ErrorMessages.php');

    require_once('_header_footer.php');
    demo_header($_REQUEST['func']);
    demo_menu();
    demo_title(); 
    
    global $tranzAdatok;
?>

<?php if (is_null($tranzAdatok)) { ?>
    <h2 class="hiba">A tranzakci nem hajtdott vgre, a banki vlasz vlasz nem rhet el vagy nem rtelmezhet.</h2>
<?php } else if ($tranzAdatok->isSuccessful()) { ?>
    <?php if ($tranzAdatok->isCsakRegisztracio()) { ?>
        <h2 class="siker">Sikeres (teszt) regisztrls</h2>
    <?php } else { ?>
        <h2 class="siker">Sikeres (teszt) vsrls</h2>
    <?php } ?>
<?php } else { ?>
    <h2 class="hiba">Sikertelen (teszt) vsrls</h2>
<?php } ?>

<?php if (!is_null($tranzAdatok)) { ?>

    <table class="eredmenytabla1">
      <tr>
        <th>Tranzakci azonosit:</th>
        <td><?php echo $tranzAdatok->getAzonosito() ?></td>
      </tr>
      <tr>
        <th>Shop ID:</th>
        <td><?php echo $tranzAdatok->getPosId() ?></td>
      </tr>

      <tr>
        <th>Sttusz kd:</th>
        <td><?php echo $tranzAdatok->getStatuszKod() ?></td>
      </tr>
      <tr>
        <th>(POS) Vlasz kd:</th>
        <td>
            <?php if (!$tranzAdatok->isSuccessful()) { 
                    $errorMsg = getMessageText($tranzAdatok->getPosValaszkod());
               }
               echo $tranzAdatok->getPosValaszkod() . ($errorMsg ? " - " . $errorMsg : "");
            ?>
        </td>
      </tr>
      <tr>
        <th>Teljesites idpontja:</th>
        <td><?php echo $tranzAdatok->getTeljesites() ?></td>
      </tr>
    </table>  
    
    <?php if ($tranzAdatok->getStatuszKod() == "VEVOOLDAL_VISSZAVONT") return; ?>
    
    <table class="eredmenytabla1">
        <?php if (!$tranzAdatok->isCsakRegisztracio() && $tranzAdatok->isSuccessful()) { ?>
          <tr>
            <th>Authorizcis kd:</th>
            <td><?php echo $tranzAdatok->getAuthorizaciosKod() ?></td>
          </tr>
        <?php } ?>

        <?php if (!$tranzAdatok->isCsakRegisztracio()) { ?>
            
            <?php if ($tranzAdatok->isNevKell()) { ?>
            <tr>
                <th>Nv</th>
                <td><?php echo $tranzAdatok->getNev() == null ? "" : $tranzAdatok->getNev() ?></td>
            </tr>
            <?php } ?>


            <?php if ($tranzAdatok->isOrszagKell()) { ?>
            <tr>
                <th>Orszg</th>
                <td><?php echo $tranzAdatok->getOrszag() == null ? "" : $tranzAdatok->getOrszag() ?></td>
            </tr>
            <?php } ?>

            <?php if ($tranzAdatok->isMegyeKell()) { ?>
            <tr>
                <th>Megye</th>
                <td><?php echo $tranzAdatok->getMegye() == null ? "" : $tranzAdatok->getMegye() ?></td>
            </tr>
            <?php } ?>

            <?php if ($tranzAdatok->isTelepulesKell()) { ?>
            <tr>
                <th>Teleples</th>
                <td><?php echo $tranzAdatok->getVaros() == null ? "" : $tranzAdatok->getVaros() ?></td>
            </tr>
            <?php } ?>

            <?php if ($tranzAdatok->isUtcaHazszamKell()) { ?>
            <tr>
                <th>Utca / hzszm</th>
                <td><?php echo $tranzAdatok->getUtcaHazszam() == null ? "" : $tranzAdatok->getUtcaHazszam() ?></td>
            </tr>
            <?php } ?>

            <?php if ($tranzAdatok->isIranyitoszamKell()) { ?>
            <tr>
                <th>Irnytszm</th>
                <td><?php echo $tranzAdatok->getIranyitoszam() == null ? "" : $tranzAdatok->getIranyitoszam() ?></td>
            </tr>
            <?php } ?>

            <?php if ($tranzAdatok->isKozlemenyKell()) { ?>
            <tr>
                <th>Kzlemny</th>
                <td><?php echo $tranzAdatok->getKozlemeny() == null ? "" : $tranzAdatok->getKozlemeny() ?></td>
            </tr>
            <?php } ?>
        
        
        <?php } ?>

    </table>

<?php } else { ?>

    <table class="eredmenytabla1">
      <tr>
        <th>Tranzakci azonosit:</th>
        <td><?php echo $_REQUEST['tranzakcioAzonosito'] ?></td>
      </tr>
      <tr>
        <th>Shop ID:</th>
        <td><?php echo $_REQUEST['posId'] ?></td>
      </tr>
    </table>

<?php } ?>
<?php demo_footer(); ?>